// base object.
Object_class 	= {};
Object_class_count 	= 0;

// Best be global. so we dont keep recreating it on a per object basis. - Chad
local ignored_tables =	{
				"_M",
				"_G",
				"_E",
				"_R",
				"_LOADLIB",
				"_LOADED",
				"__index",
				"package",
				"loaded",
				"__parent",
				"SWEP",
				
			};
			
// create/
function Object_class:create( obj_type /*, obj_parent */)
	local obj = {};
	setmetatable( obj, self );
	self.__index = self;

	Object_class_count = Object_class_count + 1;
	obj.obj_name = "base object" .. Object_class_count;
	obj.obj_type = obj_type;
	obj:reset();
	
	return obj;
end


// add an onDestroy handler.
function Object_class:onDestroy( method )
	table.insert( self.destroy_methods, method );
end


// reset.
function Object_class:reset( )
	self.__parent = nil // now handled in addChild
	self.obj_children = {}; // just to show they exist
	self.destroy_methods = {};
end


// get parent.
function Object_class:getParent()
	return self.__parent;
end

// ^ alias ^
function Object_class:parent()
	return self:getParent();
end

// set name.
function Object_class:setObjectName( name )
	if ( !name ) then return; end
	
	self.obj_name = name;
end

// get name.
function Object_class:getObjectName()
	return self.obj_name;
end

// add child.
function Object_class:addChild( obj )
	obj.__parent = self;
	table.insert( self.obj_children, obj );
end

// destroy children.
function Object_class:destroyChildren( obj )
	// run onDestroy.
	local mthd;
	for _, mthd in pairs( self.destroy_methods ) do
		// call it.
		if( self[mthd] ) then self[mthd]( self ); end
	end
	
	// Destroy all children.
	local child;
	for _, child in pairs( obj.obj_children ) do
		if( child.destroy ) then child:destroy(); end
	end
	
	// Clear table?
	obj.obj_children = {};
end

// remove reference.
// recursively removes every reference to tbl in the search table.
function Object_class:removeReference( search , tbl )
	local obj, key;
	for key, obj in pairs( search ) do
		if( obj == tbl ) then
			search[ key ] = nil;
		else
			if( type( obj ) == "table" && !table.HasValue( ignored_tables, key ) ) then
				self:removeReference( obj, tbl );
			end
		end
	end
end

// destroy.
function Object_class:destroy()
	// Destroy Children - Chad
	self:destroyChildren( self );

	// Remove references.
	self:removeReference( _G, self );
end


// get children.
function Object_class:getChildren( obj_type )
	// No type specified, return them all
	if ( !obj_type ) then return self.obj_children; end
	
	local results;
	
	local child;
	for _, child in pairs( self.obj_children ) do
		// Check if type matches our filter
		if ( child.obj_type == obj_type ) then
			results = results or {};
			// Add to results
			table.insert( results , child );
		end
	end
	
	return results;
end


// get children recursive.
function Object_class:getChildrenRecursive( obj_type, tbl_results )
	tbl_results = tbl_results or {};
	
	// copy the children over.
	local children = self:getChildren() or {};
	local child;
	for _, child in pairs( children ) do
	
		// Save child.
		if( !table.HasValue( tbl_results, child ) && ( !obj_type || child.obj_type == obj_type ) ) then
			table.insert( tbl_results, child );
		end
		
		// Iterate their children.
		tbl_results = child:getChildrenRecursive( obj_type, tbl_results );
	end 
	
	return tbl_results;
end

